//*** [vO (FeCr_PD_2D_001.java)] ************************************************
//*** [C|[g] ****************************
import java.awt.*;
import java.awt.event.*;
import java.io.*;

public class FeCr_PD_2D_001 extends Frame{

//*** [O[oϐ] *****************************************************************************************
	static int ND=64;			//gDPӂ̕
	static int nd=ND;			//Zx̕
	static int ndm=ND-1;	//Zx̕-1
	static int width;			// WindowŜ̕
	static int height;			// WindowŜ̍
	static int xwidth;			// `̈̕
	static int yheight;			// `̈̍
	static int insetx;			// Window̘g̕iEщj
	static int insety;			// Window̘g̕ij
	static double PI=3.141592;						//
	static double RR=8.3145;						//KX萔
	static double [][] ch=new double[ND][ND];	//gD̔Zxf|^z
	static Graphics g;								//RGlM[Ȑʂ̃OtBbNXIuWFNg
	static double time1;								//vZԁiJEgj
	static double temp; 								//x(K)
	static double c0;									//gij


//*** [RXgN^] ****************************
	public FeCr_PD_2D_001(){
		xwidth=400; yheight=400; 			//`ʂ̉Əc̒isNZPʁj
		insetx=4; insety=30;					//`ʂ̘g̒
		width=xwidth+insetx*2;  			//`WindowŜ̉̒
		height=yheight+insetx+insety; 	//`WindowŜ̏c̒
		setSize(width, height);				//`Window̃Zbg
		setBackground(Color.white); 		//`Window̕`敔̐F𔒂ɐݒ
		setVisible(true); 						//`Window悤ɂ
		addWindowListener(new WindowAdapter(){ 
			public void windowClosing(WindowEvent e){ System.exit(0); }
												//Window鎞̑iWindow̉E~̐ݒj
		});
	}

//*** [main vO] *****************************
	public static void main(String[] args) throws Exception{//O͍sȂ

		FeCr_PD_2D_001 prog=new FeCr_PD_2D_001();	//FeCr_PD_2D_001̃CX^Xprog𐶐

		int i, j; 										//
		int ip, im, jp, jm; 								//ii+1, i-1, j+1, j-1j
		double delt;									//ԍ݁ij
		double al;										//vZ̈̂Pӂ̒
		double time1max;							//vZԁiőJEgj
		double [][] ck = new double[ND][ND];		//gU|eV
		double [][] ch2 = new double[ND][ND]; 	//gD̔Zxf|^\z
		double mu_chem, mu_surf, mu_str, mu_mag;			//e|eV
		double c1, c2;								//Zx(Fe:1, Cr:2)
		double a01, atomNo;			//Fe(bcc)̊iq萔ƁAPʖĚq
		double vm0;													//molar volume

		double L0;									//qԑݍpp[^
		double L0_0, L0_1;					//qԑݍpp[^̌W
		double kappa_c;								//ZxzGlM[W

		double eta;										//iq~X}b`
		double c11a, c12a, c44a;			//Fe(bcc)̒e萔
		double c11b, c12b, c44b;			//Cr(bcc)̒e萔
		double c11, c12, c44;					//Ŝ̒e萔
		double y100;									//eGlM[֐

		//CߏGlM|֘Ap|^
		double Tc, d2Tc;												//L|xAт̑gɑ΂
		double tau;														//L|xŋKix
		double ftau, dftau;											//CߏGlM|֐Ɖxɑ΂
		double Bc, d2Bc;											//{|AqAт̑gɑ΂
		double TcFe, TcCr, TcCrFe0, TcCrFe1; //L[x֘ǍW
		double BcFe, BcCr, BcCrFe0; 				//{[Aq֘ǍW
		double p_mag, D_mag;										//pD

		double Mc;									//Փx֐Ƃ̔
		double c_flu;									//Zx̗h炬̑傫
		double cddtt;									//Zx̑

		double b1;									//ubNTCY
		double c2ip, c2im, c2jp, c2jm; 			//ubNɂc2𒆐SɁȀ㉺E̔Zx
		double sumc, dc; 							//Zx̑aAϑĝ


//---- ep[^ݒ ----------------------------------------------------
		temp=673.0;  			//[K]
		c0=0.5;					//̕ϑgiłA-30at%Bݒ肵Ăj
		delt=0.02;					//Ԃ
		time1=0.0;				//vŽJԂ
		time1max=1.0e+08;		//JԂ񐔂̍ől

		al=30.0; 					//QvZ̈̂Pӂ̒(nm)
		al=al*1.0e-9;				//(m)ɕϊ
		b1=al/(double)nd;		//PubÑTCY

		a01=0.28664e-09;			//iq萔(bcc Fe) (m)
		atomNo=2.0;			//PʖĚq
		vm0=6.02E23*a01*a01*a01/atomNo;//̐

		L0_0=20500.0;		//qԑݍpp[^iJ/moljFe-Cr(bcc)
		L0_1=-9.68;		//L=L0_0+L0_1*T
		L0=(L0_0+L0_1*temp)/RR/temp; 			//qԑݍpp|^̖

		kappa_c=2.0e-15;			//ZxzGlM|WAPʂ[J m^2/mol]
		kappa_c=kappa_c/b1/b1/RR/temp;		//ZxzGlM|WA(b1^2*rr*temp)Ŗ

		eta=0.00614;	//iq~X}b`

		c11a=2.3310e+11; 	//bccFe̒e萔(Pa)
		c12a=1.3544e+11;
		c44a=1.1783e+11;

		c11b=3.500e+11; 		//bccCr̒e萔(Pa)
		c12b=0.678e+11;
		c44b=1.008e+11;

		c11a=c11a*vm0/RR/temp; 						//RTŖ
		c12a=c12a*vm0/RR/temp;
		c44a=c44a*vm0/RR/temp;
		c11b=c11b*vm0/RR/temp;
		c12b=c12b*vm0/RR/temp;
		c44b=c44b*vm0/RR/temp;

		c11=(1.0-c0)*c11a+c0*c11b;					//̒e
		c12=(1.0-c0)*c12a+c0*c12b;
		c44=(1.0-c0)*c44a+c0*c44b;

		y100=c11+c12-2.0*(c12*c12/c11);			//e̊֐Y<100>

		TcFe=1043.0; TcCr=-311.5; TcCrFe0=1650.0; TcCrFe1=550.0;//L[x֘ǍW
		BcFe=2.22;   BcCr=-0.008; BcCrFe0=-0.85;//{[Aq֘ǍW
		p_mag=0.4;											//(bcc)
		D_mag=518.0/1125.0+11692.0/15975.0*(1.0/p_mag-1.0);

		Mc=c0*(1.0-c0);			//gÜՓx
		c_flu=0.1;

//---- 0ɂ鏉Zxݒ ----------------------------------------------------
		prog.ini_comp_field();
		//prog.datin();				//t@Cǂݍޏꍇ

//---- Zx̎ԔW̌vZ ----------------------------------------------------
		while(time1<=time1max){

//---- Zx̕\ ----------------------------------------------------
			//JEg200̔{ɔZx`
			if((((int)(time1) % 100)==0)){ prog.update_draw(g); }	//`掞̃`cL}邽
			//if((((int)(time1) % 200)==0)){ prog.repaint(); }

//---- Zx̕ۑ ----------------------------------------------------
			if((((int)(time1) % 200)==0)){ prog.datsave(); }			//JEg200̔{ɔZxۑ
			//if(time1==3000.0){ prog.datsave(); }						//JEg3000̎ɔZxۑ

//---- gU|eV̌vZ -----------------------------------------------------
			for(i=0;i<=ndm;i++){
				for(j=0;j<=ndm;j++){
					ip=i+1; im=i-1; jp=j+1; jm=j-1;
					if(i==ndm){ip=0;}  if(i==0){im=ndm;} 	//IE
					if(j==ndm){jp=0;}  if(j==0){jm=ndm;} 	//IE

					c2=ch[i][j]; 		c1=1.0-c2; 				//ʒu(i,j)ɂc1c2
					c2ip=ch[ip][j]; c2im=ch[im][j]; 
					c2jp=ch[i][jp]; c2jm=ch[i][jm]; //ɂc2̑O㍶E̔Zx

		 			mu_chem=L0*(c1-c2)+Math.log(c2)-Math.log(c1); 				//w|eV
					mu_surf=-2.0*kappa_c*(c2ip+c2im+c2jp+c2jm-4.0*c2);		//Zxz̃|eV
					mu_str=2.0*eta*eta*y100*(c2-c0); 								//e|eV

					//Tc=TcFe*c1+TcCr*c2;//L[x
					//d2Tc=-TcFe+TcCr;//TcCrg
					//Bc=BcFe*c1+BcCr*c2;//Pq̎̋i{[AqŖj
					//d2Bc=-BcFe+BcCr;//BcCrg

					Tc=TcFe*c1+TcCr*c2+c1*c2*(TcCrFe0+TcCrFe1*(c2-c1));//L[x
					d2Tc=-TcFe+TcCr+2.0*TcCrFe1*c1*c2+(c1-c2)*(TcCrFe0+TcCrFe1*(c2-c1));//TcCrg
					Bc=BcFe*c1+BcCr*c2+BcCrFe0*c1*c2;//Pq̎̋i{[AqŖj
					d2Bc=-BcFe+BcCr+BcCrFe0*(c1-c2);//BcCrg
					if(Tc<0.0){Tc=-Tc;  d2Tc=-d2Tc;}
					if(Bc<0.0){Bc=-Bc;  d2Bc=-d2Bc;}

					tau=temp/Tc; 															//т̒`
					if(tau<=1.0){ 
						//f()ƁAf()̃є̌vZ
						ftau=1.0-1.0/D_mag*(79.0/140.0/p_mag/tau
															+474.0/497.0*(1.0/p_mag-1.0)*( Math.pow(tau,3.0)/6.0
															+Math.pow(tau,9.0)/135.0+Math.pow(tau,15.0)/600.0) );
						dftau=-1.0/D_mag*(-79.0/140.0/p_mag/tau/tau
															+474.0/497.0*(1.0/p_mag-1.0)*( Math.pow(tau,2.0)/2.0
															+Math.pow(tau,8.0)/15.0+Math.pow(tau,14.0)/40.0) );
					}
					else{	
						ftau=-1.0/D_mag*(Math.pow(tau,-5.0)/10.0+Math.pow(tau,-15.0)/315.0
														+Math.pow(tau,-25.0)/1500.0);
						dftau=1.0/D_mag*(Math.pow(tau,-6.0)/2.0+Math.pow(tau,-16.0)/21.0
														+Math.pow(tau,-26.0)/60.0);
					}

					mu_mag=ftau/(Bc+1.0)*d2Bc-dftau*tau/Tc*d2Tc*Math.log(Bc+1.0); 
																							//CߏGlM[̃|eV

					ck[i][j]=mu_chem+mu_surf+mu_str+mu_mag;			//gU|eV

				}
			}

//---- Zx̎ԕω(`gU̍z@) ------------------------------------
			for(i=0;i<=ndm;i++){
				for(j=0;j<=ndm;j++){
					ip=i+1; im=i-1;  jp=j+1;  jm=j-1;
					if(i==ndm) {ip=0;}	if(i==0) {im=ndm;} 	//IE
					if(j==ndm) {jp=0;}	if(j==0) {jm=ndm;} 	//IE
					cddtt=Mc*(ck[ip][j]+ck[im][j]+ck[i][jp]+ck[i][jm]-4.0*ck[i][j]);		//`gU
					//ch2[i][j]=ch[i][j]+cddtt*delt; 										//Zx̎ԔW
					ch2[i][j]=ch[i][j]+( cddtt+c_flu*(2.0*Math.random()-1.0) ) *delt;	//Zx̎ԔWiZxh炬j
				}
			}

//*** [Zx̎x̕␳] *******************************************************
//*** lvZł̂ŔZx̎x̕␳siۂɂ͖XebvsKv͂ȂjB] ****
  		sumc=0.;
			for(i=0;i<=ndm;i++){
				for(j=0;j<=ndm;j++){
					sumc=sumc+ch2[i][j]; 					//Zx̐ϕ
				}
			}
			dc=sumc/(double)nd/(double)nd-c0;			//Zx̕ϓ

			for(i=0;i<=ndm;i++){
				for(j=0;j<=ndm;j++){
					ch[i][j]=ch2[i][j]-dc; 						//Zx̕␳
					if(ch[i][j]>=1.){ch[i][j]=1.0-1.0e-6;} 	//Zx1𒴂ꍇ̕␳
					if(ch[i][j]<=0.){ch[i][j]=1.0e-6;} 			//Zx0؂ꍇ̕␳
				}
			}

//******[ԑ]*************************************************
			time1=time1+1.0; 	//vZԂ̑
		}//while

//----------------------------------------------------------------

		System.out.printf("\n I܂BOt̉E~NbNďIĂB\n");

}//main

// ȉ̓Tu[`łB
// **** Zxݒ *****************************************************
	public void ini_comp_field(){
		int i, j;
		double rnd0, fac1;

		fac1=0.01; 	//Zxh炬̍őωʂ1%ɐݒ
		for(i=0;i<=ndm;i++){
			for(j=0;j<=ndm;j++){
				rnd0=2.0*Math.random()-1.0;  ch[i][j]=c0+rnd0*fac1; 	//ɂďZxݒ
			}
		}

	}

// *********************************************************
//`cLh~̂draw֐ʂɒ`
	public void update_draw( Graphics g ){ g=getGraphics(); paint(g); }

// **** Zx` *****************************************************
	public void paint(Graphics g){
		//g.clearRect(0, 0, width, height);		//WindowNA

		int i, j, ii, jj;
		double c, x, xmax, xmin, y, ymax, ymin, rad0;
		int ixmin=0, iymin=0, igx, igy, irad0;
		int ixmax=xwidth, iymax=yheight;
		int icol;

		xmin=0.; xmax=1.; 						//̍ŏlAől
		ymin=0.; ymax=1.; 						//c̍ŏlAől

		rad0=1.0/(double)nd/2.0; 				//ubN̒̔
		irad0=1+(int)( ((double)ixmax-(double)ixmin)/(xmax-xmin)*rad0 ); 	//rad0̃sNZ

		System.out.printf("%f \n", time1); 	//vŽJԂ񐔂Wo͂ɕ\

		for(i=0;i<=nd;i++){
			for(j=0;j<=nd;j++){
				//ZẍʒuWiۂ̒lj
				x=1.0/(double)nd*(double)i+rad0;
				y=1.0/(double)nd*(double)j+rad0;
				//ZẍʒuWiXN[Wɕϊj
				igx=(int)( ((double)ixmax-(double)ixmin)*(x-xmin)/(xmax-xmin)+(double)ixmin );
				igy=(int)( ((double)iymax-(double)iymin)*(y-ymin)/(ymax-ymin)+(double)iymin );

				//X̍ubN̔Zxl
				ii=i; jj=j;
				if(i==nd){ii=0;} if(j==nd){jj=0;}											//IE
				icol=(int)(255.0*(1.0-ch[ii][jj]));											//F~O[XP[ɂ
				//icol=(int)(255.0*ch[ii][jj]);												//Â𔽓]ꍇ
				if(icol>=255){icol=255;} if(icol<=0){icol=0;}							//Â͈̔͂̕␳
				g.setColor(new Color(icol,icol,icol)); 									//Zx𖾈ÂŐݒ
				g.fillRect(insetx+igx-irad0,insety+igy-irad0, irad0*2, irad0*2);		//X̍ubN`
			}
		}
	}

//*** [f|^̕ۑ] ************************************
	private void datsave() throws Exception{
		int	i, j;

		//ۑt@Ctest.datƂB
		PrintWriter outfile= new PrintWriter(
			new BufferedWriter(new FileWriter("test.dat", true)) );		//t@C̃I[vǋL

		outfile.println(time1);				//JEg̏
		for(i=0;i<=ndm;i++){
			for(j=0;j<=ndm;j++){
				outfile.println(ch[i][j]);		//Zx̏
			}
		}
		outfile.close();						//t@C̃N[Y
	}

//*** [f|^̓Ǎ] ************************************
	private void datin() throws Exception{
		int	i, j;
		String s_data;

		BufferedReader infile=new BufferedReader(new FileReader("ini000.dat"));//t@C̃I[v

		s_data=infile.readLine();  									//ēǂݍ
		time1=new Double(s_data).doubleValue();				//𐔒l֕ϊ
		for(i=0;i<=ndm;i++){
			for(j=0;j<=ndm;j++){
				s_data=infile.readLine();  							//ēǂݍ
				ch[i][j]=new Double(s_data).doubleValue();		//𐔒l֕ϊ
			}
		}
		infile.close();													//t@C̃N[Y
	}

//****************************************************************
}//FeCr_PD_2D_001
//*** vOI ************************************************************
